/*
 * Decompiled with CFR 0.152.
 */
package energon.srpextra.config.preset;

import com.dhanantry.scapeandrunparasites.entity.ai.misc.EntityParasiteBase;
import com.dhanantry.scapeandrunparasites.util.config.SRPConfig;
import energon.srpextra.config.preset.IConfigBase;
import energon.srpextra.util.SRPELootTable;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraftforge.common.config.Configuration;

public class ParasiteConfig
implements IConfigBase {
    public boolean active;
    public float followRange;
    public float movementSpeed;
    public float attackDamage;
    public float armor;
    public float armorToughness;
    public float knockbackResistance;
    public float health;
    public SRPELootTable.LootTable lootTable;
    public String[] lootTableBase;
    public int lootMaxRoll = 100;
    public boolean dropOneTypeItem = false;

    public ParasiteConfig(boolean active, float followRange, float movementSpeed, float attackDamage, float armor, float armorToughness, float knockbackResistance, float health, String[] lootTable) {
        this.active = active;
        this.followRange = followRange;
        this.movementSpeed = movementSpeed;
        this.attackDamage = attackDamage;
        this.armor = armor;
        this.armorToughness = armorToughness;
        this.knockbackResistance = knockbackResistance;
        this.health = health;
        this.lootTableBase = lootTable;
    }

    public void init(Configuration config, String category) {
        this.active = config.getBoolean(" Active", category, this.active, "Set to false if you want to disable entity.");
        this.followRange = config.getFloat("# Follow Range", category, this.followRange, 0.0f, 128.0f, "Follow range.");
        this.movementSpeed = config.getFloat("# Movement Speed", category, this.movementSpeed, 0.0f, 99.0f, "Movement speed.");
        this.attackDamage = config.getFloat("# Attack Damage", category, this.attackDamage, 0.0f, 999999.0f, "Attack damage (melee).");
        this.armor = config.getFloat("# Armor", category, this.armor, 0.0f, 999999.0f, "Armor.");
        this.armorToughness = config.getFloat("# Armor Toughness", category, this.armorToughness, 0.0f, 999999.0f, "Armor Toughness.");
        this.knockbackResistance = config.getFloat("# Knockback Resistance", category, this.knockbackResistance, 0.0f, 999999.0f, "Knockback resistance.");
        this.health = config.getFloat("# Health", category, this.health, 0.0f, 999999.0f, "Health.");
        this.lootTableBase = config.getStringList("$ Loot Table", category, this.lootTableBase, "Loot TableEx. \"100;minecraft:nether_star;0;5;1\" Where:  \n \"100\" is the chance to drop (100%), \n \"minecraft:nether_star\" is the item, \n \"0\" is the meta of items, \n \"5\" is the max number of items, \n \"1\" is the min number of items  \n");
        this.lootTable = SRPELootTable.generate(category, this.lootTableBase);
    }

    @Override
    public void addBaseAttributes(EntityLivingBase entity) {
        entity.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a((double)this.followRange);
        entity.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a((double)this.movementSpeed);
        entity.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a((double)this.getAttackDamage());
        entity.func_110148_a(SharedMonsterAttributes.field_188791_g).func_111128_a((double)this.getArmor());
        entity.func_110148_a(SharedMonsterAttributes.field_189429_h).func_111128_a((double)this.armorToughness);
        entity.func_110148_a(SharedMonsterAttributes.field_111266_c).func_111128_a((double)this.getKnockbackResistance());
        entity.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a((double)this.getHealth());
    }

    @Override
    public String[] getLootTableBase() {
        return this.lootTableBase;
    }

    @Override
    public SRPELootTable.LootTable getLootTable() {
        if (this.lootTable != null) {
            return this.lootTable;
        }
        this.lootTable = SRPELootTable.generate(this.lootTableBase);
        return this.lootTable;
    }

    @Override
    public void spawnDeathLoot(EntityLivingBase dead) {
        if (this.lootTable != null) {
            this.lootTable.spawnLoots(dead, this.lootMaxRoll);
        }
    }

    @Override
    public float getHealth() {
        return this.health * SRPConfig.globalHealthMultiplier;
    }

    @Override
    public float getArmor() {
        return this.armor * SRPConfig.globalArmorMultiplier;
    }

    @Override
    public float getKnockbackResistance() {
        return this.knockbackResistance * SRPConfig.globalKDResistanceMultiplier;
    }

    @Override
    public float getAttackDamage() {
        return this.attackDamage * SRPConfig.globalDamageMultiplier;
    }

    @Override
    public float getMovementSpeed() {
        return this.movementSpeed;
    }

    @Override
    public float getFollowRange() {
        return this.followRange;
    }

    @Override
    public float getArmorToughness() {
        return this.armorToughness;
    }

    @Override
    public void addCustomStats(EntityParasiteBase parasite) {
    }

    @Override
    public void addCustomAI(EntityParasiteBase parasite) {
    }
}

